#ifndef __CDisplayInformation__
#define __CDisplayInformation__


#include "../Basics/CString.hpp"
#include "../IO/CTextStream.hpp"

//	===========================================================================

using Exponent::Basics::CString;
using Exponent::IO::CTextStream;

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CDisplayInformation CDisplayInformation.hpp
		 * @brief Gives informaiton about the displays attatched to the system
		 *
		 * @date 27/09/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.1.0 Added text stream output
		 * @version 1.1.1 Updated monitor interogation on mac to support CGDisplay routines, rather than depricated GDevice style
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CDisplayInformation.hpp,v 1.5 2007/03/03 14:45:32 paul Exp $
		 */
		class CDisplayInformation
		{
		public:

//	===========================================================================

			/**
			 * Dump the monitor informaiton to disk
			 * @param path The path to store to
			 */
			static void dumpDisplayInfoToFile(const CSystemString &path);

			/**
			 * Dump the monitor informaiton to disk
			 * @param stream The stream to store to
			 */
			static void dumpDisplayInfoToFile(CTextStream &stream);

//	===========================================================================

			/**
			 * Get the number of monitors on the system
			 * @retval long The number of monitors attatched
			 */
			static long getNumberOfMonitors();

			/**
			 * Get the screen width
			 * @retval long The monitor width in pixels
			 */
			static long getMonitorScreenWidth();

			/**
			 * Get the screen height
			 * @retval long The monitor height in pixels
			 */
			static long getMonitorScreenHeight();

			/**
			 * Get the window border width
			 * @retval long Border width in pixels
			 */
			static long getWindowBorderWidth();

			/**
			 * Get the window border height
			 * @retval long Border height in pixels
			 */
			static long getWindowBorderHeight();
		};
	}
}
#endif	// End of CDisplayInformation.hpp